'==========================================================================
'
' Author......: Raffaele Chiatto
'
' WebSite.....: http://www.raffaelechiatto.com
'
' E-Mail......: raffaele.chiatto@gmail.com
'
'==========================================================================

Option Explicit

Const path =  "C:\Cartella"        			' Test folder (must exist)
Const file1 = "C:\Cartella\File_Sorgente.txt"           ' Source file (must exist)
Const file2 = "C:\Cartella\File_Target.txt"             ' Target file 

Dim Text, Title, i 
Dim fso, oFile, oFolder                ' Object variables

Text = "File copied" & vbCrLf
Title = "WSH sample - by G. Born"

' Create FileSystemObject object to access file system.
Set fso = CreateObject("Scripting.FileSystemObject")

' Check whether file exists.
If (fso.FileExists(file1)) Then
    ' Copy file1 to file2 (or use fso.CopyFile file1, file2).
    Set oFile = fso.GetFile(file1)      ' Get File object.
    oFile.Copy file2, True              ' Overwrite existing target.

    Set oFolder = fso.GetFolder(path)
    Set oFile = oFolder.Files           ' Get Files collection.
    For Each i In oFile                 ' All files
        Text = Text & i.Name & vbCrLf
    Next

    MsgBox Text, vbOKOnly + vbInformation, Title
Else
    WScript.Echo "File " & file1 & " doesn't exist"
    WScript.Quit
End If

' Delete file upon request.
If (MsgBox("Delete file?", vbYesNo, Title) = vbYes) Then
    Set oFile = fso.GetFile(file2)      ' Fetch File object.
    oFile.Delete       ' (or use fso.CopyFile file2)
    WScript.Echo "File " & file2 & " deleted"
End If

'*** End